function textCounter( field, maxlimit ) {
  if ( field.value.length > maxlimit ) {
	field.value = field.value.slice(0,maxlimit);
    return false;
	}
}

function trim(value) {
  value = value.replace(/^\s+/,'');
  value = value.replace(/\s+$/,'');
  return value;
}

function focusMove(thisElem, evt) {
    evt = (evt) ? evt : event;
    var charCode = (evt.charCode) ? evt.charCode :
        ((evt.which) ? evt.which : evt.keyCode);
    if (charCode == 13) {
		for (var i=0; i < (document.form.elements.length-1); i++) {
			if (document.form.elements[i].name == thisElem.name) {
				// Found our element, find the first not hidden element to give the focus to
				for (var j=i+1; j < (document.form.elements.length-1); j++) {
					if (document.form.elements[j].type != 'hidden' && document.form.elements[j].disabled==false) {
						document.form.elements[j].focus();
						return true;
					}
				}
			}
		}
    }
}

function show_autocomplete_info() {
	var info = 'Begin met invullen, na drie letters zal er een lijst verschijnen waaruit u een keuze moet maken...';
	alert(info);
}

function show_filetype_info_1() {
	var info = 'Toegestane bestandstypes zijn afbeeldingen (gif/bmp/jpg/png), Word, OpenOffice en pdf bestanden...';
	alert(info);
}

function show_filetype_info_2() {
	var info = 'Toegestane bestandstypes zijn afbeeldingen (gif/bmp/jpg/png) en pdf bestanden...';
	alert(info);
}

function doAfterUpdateElement(inputField, selectedItem) {
	var hiddenFieldId = 'idnr_' + inputField.id;
	var hiddenFieldElement = document.getElementById(hiddenFieldId);
	
	hiddenFieldElement.value = selectedItem.id;
	hiddenFieldElement.title = selectedItem.innerHTML;
}

function doOnBlurSelect(inputElement) {
	var hiddenFieldId =  'idnr_' + inputElement.id;
	var hiddenFieldElement = document.getElementById(hiddenFieldId);
	//When the element looses its focus, check if a valid item was selected.
	if (trim(inputElement.value) == '') {
		//Element made empty
		hiddenFieldElement.value = '0';
		hiddenFieldElement.title = '';
	} else if (trim(inputElement.value) == trim(hiddenFieldElement.title)) {
		inputElement.value = hiddenFieldElement.title
	} else {
		//Value was not valid, but not empty
		if (hiddenFieldElement.value != '0') {
			inputElement.value = hiddenFieldElement.title
		} else {
			inputElement.value = ''
		}
	}
}

function init_autocompleter(inputElement) {
	var hiddenFieldId =  'idnr_' + inputElement.id;
	var hiddenFieldElement = document.getElementById(hiddenFieldId);
	if (hiddenFieldElement.value == '0') {
		inputElement.value = '';
	} else {
		hiddenFieldElement.title = inputElement.value;
	}
}


function init_autocomplete() {
	new Ajax.Autocompleter('opleiding[1]','opleiding_choices','searchtree.htm', {
		paramName: "value",
		minChars: 3,
		frequency: 0.5,
		afterUpdateElement: doAfterUpdateElement,
		parameters: "type=opleiding"
		});
	init_autocompleter(document.getElementById('opleiding[1]'));

    new Ajax.Autocompleter('opleiding[2]','opleiding_choices','searchtree.htm', {
		paramName: "value",
		minChars: 3,
		frequency: 0.5,
		afterUpdateElement: doAfterUpdateElement,
		parameters: "type=opleiding"
		});
	init_autocompleter(document.getElementById('opleiding[2]'));

    new Ajax.Autocompleter('opleiding[3]','opleiding_choices','searchtree.htm', {
		paramName: "value",
		minChars: 3,
		frequency: 0.5,
		afterUpdateElement: doAfterUpdateElement,
		parameters: "type=opleiding"
		});
	init_autocompleter(document.getElementById('opleiding[3]'));


	new Ajax.Autocompleter('functie[1]','werkervaring_choices','searchtree.htm', {
		paramName: "value",
		minChars: 3,
		frequency: 0.5,
		afterUpdateElement: doAfterUpdateElement,
		parameters: "type=functie"
		});
	init_autocompleter(document.getElementById('functie[1]'));

    new Ajax.Autocompleter('functie[2]','werkervaring_choices','searchtree.htm', {
		paramName: "value",
		minChars: 3,
		frequency: 0.5,
		afterUpdateElement: doAfterUpdateElement,
		parameters: "type=functie"
		});
	init_autocompleter(document.getElementById('functie[2]'));

    new Ajax.Autocompleter('functie[3]','werkervaring_choices','searchtree.htm', {
		paramName: "value",
		minChars: 3,
		frequency: 0.5,
		afterUpdateElement: doAfterUpdateElement,
		parameters: "type=functie"
		});
	init_autocompleter(document.getElementById('functie[3]'));


	new Ajax.Autocompleter('vaardigheid[1]','vaardigheid_choices','searchtree.htm', {
		paramName: "value",
		minChars: 3,
		frequency: 0.5,
		afterUpdateElement: doAfterUpdateElement,
		parameters: "type=vaardigheid"
		});
	init_autocompleter(document.getElementById('vaardigheid[1]'));

    new Ajax.Autocompleter('vaardigheid[2]','vaardigheid_choices','searchtree.htm', {
		paramName: "value",
		minChars: 3,
		frequency: 0.5,
		afterUpdateElement: doAfterUpdateElement,
		parameters: "type=vaardigheid"
		});
	init_autocompleter(document.getElementById('vaardigheid[2]'));

    new Ajax.Autocompleter('vaardigheid[3]','vaardigheid_choices','searchtree.htm', {
		paramName: "value",
		minChars: 3,
		frequency: 0.5,
		afterUpdateElement: doAfterUpdateElement,
		parameters: "type=vaardigheid"
		});
	init_autocompleter(document.getElementById('vaardigheid[3]'));

    new Ajax.Autocompleter('vaardigheid[4]','vaardigheid_choices','searchtree.htm', {
		paramName: "value",
		minChars: 3,
		frequency: 0.5,
		afterUpdateElement: doAfterUpdateElement,
		parameters: "type=vaardigheid"
		});
	init_autocompleter(document.getElementById('vaardigheid[4]'));

    new Ajax.Autocompleter('vaardigheid[5]','vaardigheid_choices','searchtree.htm', {
		paramName: "value",
		minChars: 3,
		frequency: 0.5,
		afterUpdateElement: doAfterUpdateElement,
		parameters: "type=vaardigheid"
		});
	init_autocompleter(document.getElementById('vaardigheid[5]'));

	checkRadio();
	
}

function getFileExtention(file) {
	return file.substring(file.length-4,file.length);
}

function checkRadio() {
	if (document.getElementById("geslacht_vrouw").checked) {
		document.getElementById("meisjes_voorvoegsels").disabled = false;
		document.getElementById("meisjes_achternaam").disabled = false;
	} else {
		document.getElementById("meisjes_voorvoegsels").disabled = true;
		document.getElementById("meisjes_voorvoegsels").value = "";
		document.getElementById("meisjes_achternaam").disabled = true;
		document.getElementById("meisjes_achternaam").value = "";
	}
}

function daysInFebruary (year){
	// February has 29 days in any year evenly divisible by four,
    // EXCEPT for centurial years which are not also divisible by 400.
    return (((year % 4 == 0) && ( (!(year % 100 == 0)) || (year % 400 == 0))) ? 29 : 28 );
}
function DaysArray(n) {
	for (var i = 1; i <= n; i++) {
		this[i] = 31
		if (i==4 || i==6 || i==9 || i==11) {this[i] = 30}
		if (i==2) {this[i] = 29}
   }
   return this
}

function isDate(day, month, year){
	var daysInMonth = DaysArray(12);
	if (month<1 || month>12){
		return false
	}
	if (day<1 || day>31 || (month==2 && day>daysInFebruary(year)) || day > daysInMonth[month]){
		return false
	}
	if (year==0){
		return false
	}

	return true
}

function validBSNorEmpty(bsn) {
	if (isEmpty(bsn)) return true;
	if (!isInteger(bsn)) return false;
	CheckNum = parseInt(bsn,10);
	if (isNaN(CheckNum)) return false;
	if (!(bsn.length == 8 || bsn.length == 9)) return false;
	//
	var total = 0;
	var mp = bsn.length;
	
	for( var i = 0; i < bsn.length-1; i++ ) {
		total += bsn.charAt( i ) * mp;
		mp -= 1;
	}
	var result = ( total % 11 );
	if (result < 10) {
		return result == bsn.charAt( bsn.length-1 )
	} else {
		return false
	}
}

function isInteger (s) {
	var i;

	for (i = 0; i < s.length; i++) {
		var c = s.charAt(i);

		if (!isDigit(c)) return false;
	}

	return true;
}

function isEmpty(s){
	return ((s == null) || (s.length == 0));
}

function isDigit (c){
	return ((c >= "0") && (c <= "9"));
}

function validZipcodeOrEmpty(country, zipcode) {
	if (country == 'NL' && !isEmpty(zipcode)) {
		var reZipcodeNL = new RegExp('^[1-9][0-9]{3}\\s{0,1}[a-zA-Z]{2}$');
        zipcode = trim(zipcode);
		return (reZipcodeNL.exec(zipcode) != null);
	}
	return true;
}

function validDateOrEmpty(day, month, year) {
	if (!(day == '0' && month == '0' && year == '0')) {
		return isDate(parseInt(day,10), parseInt(month,10), parseInt(year,10));
	}
	return true;
}

function validDateOrEmpty2(day, month, year) {
	if ((day == '0' && month == '0' && year == '0')) {
		return true;
	}
	if ((day == '0' && month == '0' && year != '0')) {
		return isDate(1, 1, parseInt(year,10));
	}
	if ((day == '0' && month != '0' && year != '0')) {
		return isDate(1, parseInt(month,10), parseInt(year,10));
	}
	if ((day != '0' && month != '0' && year != '0')) {
		return isDate(parseInt(day,10), parseInt(month,10), parseInt(year,10));
	}
	return false;
}

function compareDates2(day1, month1, year1, day2, month2, year2) {
	if (year1=='0' || year2=='0') return true;
	if ( !( parseInt(year1,10) == parseInt(year2,10) ) ) return (parseInt(year2,10) > parseInt(year1,10));
	//Year1==Year2
	if (month1=='0' || month2=='0') return true;
	if ( !( parseInt(month1,10) == parseInt(month2,10) ) ) return (parseInt(month2,10) > parseInt(month1,10));
	//Year1==Year2 && Month1 == Month2
	if (day1=='0' || day2=='0') return true;
	return (parseInt(day2,10) >= parseInt(day1,10));
}


function calculateAge(dayStr, monthStr, YearStr) {
	var curDate = new Date();
	var curDay = curDate.getDate();
	var curMonth = curDate.getMonth() + 1;
	var curYear = curDate.getFullYear();
	var day = parseInt(dayStr,10);
	var month = parseInt(monthStr,10);
	var year = parseInt(YearStr,10);
	if (month > curMonth || (month==curMonth && day > curDay)) {
		return (curYear - year) - 1
	} else {
		return (curYear - year)
	}
}

function validEmailOrEmpty(email) {
	if (!isEmpty(email)) {
		var reMail = new RegExp('^.+@[^\.].*\.[a-zA-Z]{2,}$');
		return (reMail.exec(email) != null);
	}
	return true;
}

function validPhoneOrEmpty(phone) {
	if (!isEmpty(phone)) {
		var rePhone = new RegExp('(^(\\((\\+|00)[0-9]{1,4}\\)|(\\+|00)[0-9]{1,4})((\\(0\\))|\\-|\\s)?[0-9]{1,5}(\\-|\\s)?[0-9]{6,8}$)|(^\\([0-9]{1,5}\\)[0-9]{6,8}$)|(^([0-9]{2,5}(\\-|\\s)?)?[0-9]{6,8}$)');
		return (rePhone.exec(phone) != null);
	}
	return true;
}

function integerOrEmpty(value) {
	return (isEmpty(value) || isInteger(value));
}

function validateOpleiding(num) {
	alertMessage = '';
	prefix = '- Opleiding ' + num + ': ';

	elemOpleidingIdnr = 'opleiding_idnr[' + num + ']';
	elemAanvangDag = 'opleiding_aanvang_dag[' + num + ']';
	elemAanvangMaand = 'opleiding_aanvang_maand[' + num + ']';
	elemAanvangJaar = 'opleiding_aanvang_jaar[' + num + ']';
	elemEindeDag = 'opleiding_einde_dag[' + num + ']';
	elemEindeMaand = 'opleiding_einde_maand[' + num + ']';
	elemEindeJaar = 'opleiding_einde_jaar[' + num + ']';
	elemVakken = 'opleiding_vakken[' + num + ']';
	elemDiploma = 'opleiding_diploma[' + num + ']';

	opl_opleidingidnr = document.getElementsByName(elemOpleidingIdnr)[0].value;
	opl_aanvang_jaar = document.getElementsByName(elemAanvangJaar)[0].value;
	opl_aanvang_maand = document.getElementsByName(elemAanvangMaand)[0].value;
	opl_aanvang_dag = document.getElementsByName(elemAanvangDag)[0].value;
	opl_einde_jaar = document.getElementsByName(elemEindeJaar)[0].value;
	opl_einde_maand = document.getElementsByName(elemEindeMaand)[0].value;
	opl_einde_dag = document.getElementsByName(elemEindeDag)[0].value;
	opl_vakken = trim(document.getElementsByName(elemVakken)[0].value);
	opl_diploma = document.getElementsByName(elemDiploma)[0].checked;

	if (opl_opleidingidnr=='0' && opl_aanvang_jaar=='0' && opl_aanvang_maand=='0' && opl_aanvang_dag=='0' &&
		opl_einde_jaar=='0' && opl_einde_maand=='0' && opl_einde_dag=='0' && opl_vakken=='' && opl_diploma==false) {
		return '';
	}

	if (opl_opleidingidnr=='0') alertMessage += (prefix + 'Opleiding is niet ingevuld\n');
	if (!validDateOrEmpty2(opl_aanvang_dag, opl_aanvang_maand, opl_aanvang_jaar)) alertMessage += (prefix + 'Aanvang is niet correct\n');
	if (!validDateOrEmpty2(opl_einde_dag, opl_einde_maand, opl_einde_jaar)) alertMessage += (prefix + 'Einde is niet correct\n');
	
	if (validDateOrEmpty2(opl_aanvang_dag, opl_aanvang_maand, opl_aanvang_jaar) && validDateOrEmpty2(opl_einde_dag, opl_einde_maand, opl_einde_jaar)) {
		if (!compareDates2(opl_aanvang_dag, opl_aanvang_maand, opl_aanvang_jaar,opl_einde_dag, opl_einde_maand, opl_einde_jaar)) {
			alertMessage += (prefix + 'Einde moet na aanvang liggen\n');
		}
	}

	return alertMessage;
}

function validateWerkervaring(num) {
	alertMessage = '';
	prefix = '- Werkervaring ' + num + ': ';

	elemBedrijfsnaam = 'werkervaring_bedrijfsnaam[' + num + ']';
	elemAdres = 'werkervaring_adres[' + num + ']';
	elemHuisnr = 'werkervaring_huisnr[' + num + ']';
	elemHuisnrTv = 'werkervaring_huisnrtv[' + num + ']';
	elemPostcode = 'werkervaring_postcode[' + num + ']';
	elemPaats = 'werkervaring_plaats[' + num + ']';
	elemLand = 'werkervaring_land[' + num + ']';
	elemAanvangJaar = 'werkervaring_aanvang_jaar[' + num + ']';
	elemAanvangMaand = 'werkervaring_aanvang_maand[' + num + ']';
	elemAanvangDag = 'werkervaring_aanvang_dag[' + num + ']';
	elemEindeJaar = 'werkervaring_einde_jaar[' + num + ']';
	elemEindeMaand = 'werkervaring_einde_maand[' + num + ']';
	elemEindeDag = 'werkervaring_einde_dag[' + num + ']';
	elemFunctieIdnr = 'werkervaring_functieidnr[' + num + ']';
	elemWerkzaamheden = 'werkervaring_werkzaamheden[' + num + ']';
	elemGetuigschrift = 'werkervaring_getuigschrift[' + num + ']';

	werv_bedrijfsnaam = trim(document.getElementsByName(elemBedrijfsnaam)[0].value);
	werv_adres = trim(document.getElementsByName(elemAdres)[0].value);
	werv_huisnr = trim(document.getElementsByName(elemHuisnr)[0].value);
	werv_huisnrtv = trim(document.getElementsByName(elemHuisnrTv)[0].value);
	werv_postcode = trim(document.getElementsByName(elemPostcode)[0].value);
	werv_plaats = trim(document.getElementsByName(elemPaats)[0].value);
	werv_land = document.getElementsByName(elemLand)[0].value;
	werv_aanvang_jaar = document.getElementsByName(elemAanvangJaar)[0].value;
	werv_aanvang_maand = document.getElementsByName(elemAanvangMaand)[0].value;
	werv_aanvang_dag = document.getElementsByName(elemAanvangDag)[0].value;
	werv_einde_jaar = document.getElementsByName(elemEindeJaar)[0].value;
	werv_einde_maand = document.getElementsByName(elemEindeMaand)[0].value;
	werv_einde_dag = document.getElementsByName(elemEindeDag)[0].value;
	werv_functieidnr = document.getElementsByName(elemFunctieIdnr)[0].value;
	werv_werkzaamheden = trim(document.getElementsByName(elemWerkzaamheden)[0].value);
	werv_getuigschrift = document.getElementsByName(elemGetuigschrift)[0].checked;

	if (werv_bedrijfsnaam=='' && werv_adres=='' && werv_huisnr=='' && werv_huisnrtv=='' && werv_postcode=='' && werv_plaats=='' &&
		werv_aanvang_jaar=='0' && werv_aanvang_maand=='0' && werv_aanvang_dag=='0' && werv_einde_jaar=='0' && werv_einde_maand=='0' && werv_einde_dag=='0' &&
		werv_functieidnr=='0' && werv_werkzaamheden=='' && werv_getuigschrift==false) {
		return '';
	}

	if (werv_bedrijfsnaam=='') alertMessage += (prefix + 'Bedrijfsnaam is niet ingevuld\n');
	if (!integerOrEmpty(werv_huisnr)) alertMessage += (prefix + 'Huisnummer is onjuist\n');
	if (!validZipcodeOrEmpty(werv_land,werv_postcode)) alertMessage += (prefix + 'Postcode is onjuist\n');
	if (!validDateOrEmpty2(werv_aanvang_dag, werv_aanvang_maand, werv_aanvang_jaar)) alertMessage += (prefix + 'Aanvang is niet correct\n');
	if (!validDateOrEmpty2(werv_einde_dag, werv_einde_maand, werv_einde_jaar)) alertMessage += (prefix + 'Einde is niet correct\n');
	
	if (validDateOrEmpty2(werv_aanvang_dag, werv_aanvang_maand, werv_aanvang_jaar) && validDateOrEmpty2(werv_einde_dag, werv_einde_maand, werv_einde_jaar)) {
		if (!compareDates2(werv_aanvang_dag, werv_aanvang_maand, werv_aanvang_jaar,werv_einde_dag, werv_einde_maand, werv_einde_jaar)) {
			alertMessage += (prefix + 'Einde moet na aanvang liggen\n');
		}
	}

	if (werv_functieidnr=='0') alertMessage += (prefix + 'Functie is niet ingevuld\n');

	return alertMessage;
}

function validateSubmitForm() {
	reVoorletters = new RegExp('^[a-zA-Z\\s.]*$');
	alertMessage = '';
	woonadres = document.form.woonadres.value;
	woonhuisnr = document.form.huisnr.value;
	woonhuisnrtv = document.form.huisnrtv.value;
	woonpostcode = document.form.postcode.value;
	woonplaats = document.form.woonplaats.value;
	woonland = document.form.woonland.value;
	// Check persoonsgegevens
	if (document.getElementById('geslacht_man').checked == false && document.getElementById('geslacht_vrouw').checked == false ) alertMessage += '- Er is geen keuze gemaakt voor geslacht\n';
	if (document.form.voorletters.value == '') alertMessage += '- Voorletters zijn niet ingevuld\n';
	if (reVoorletters.exec(document.form.voorletters.value) == null) alertMessage += '- Voorletters zijn onjuist\n';
	if (document.form.achternaam.value == '') alertMessage += '- Achternaam is niet ingevuld\n';
	if (woonadres != '' || woonhuisnr != '' || woonhuisnrtv != '' || woonpostcode != '' || woonplaats != '' || woonland != ''){
		if (woonland == '') alertMessage += '- Woonland is niet ingevuld\n';
		if (woonadres == '') alertMessage += '- Woonadres is niet ingevuld\n';
		if (woonplaats == '') alertMessage += '- Woonplaats is niet ingevuld\n';
		if (woonland == 'NL'){
			if (woonhuisnr == '') alertMessage += '- Huisnummer is niet ingevuld\n';
			if (woonpostcode == '') alertMessage += '- Postcode is niet ingevuld\n';
		}
	}
	if (woonhuisnr != ''){
		if (!integerOrEmpty(woonhuisnr)) alertMessage += '- Huisnummer is onjuist\n';
	}
	if (woonpostcode != ''){
		if (!validZipcodeOrEmpty(woonland, woonpostcode)) alertMessage += '- Postcode is onjuist\n';
	}
	//Check value for birthdate
	if (!validDateOrEmpty(document.form.geboortedatum_dag.value,document.form.geboortedatum_maand.value,document.form.geboortedatum_jaar.value) ) {
		alertMessage += '- Geboortedatum is niet correct\n';
	} else {
		if ( calculateAge(document.form.geboortedatum_dag.value,document.form.geboortedatum_maand.value,document.form.geboortedatum_jaar.value) < 13) {
			alertMessage += '- Leeftijd mag niet jonger zijn dan 13 jaar\n';
		}
	}

	//Burgerservicenr controle
	if ( !validBSNorEmpty(document.form.burgerservicenummer.value) )  alertMessage += '- Burgerservicenummer is niet correct.\n';
	
	if (document.form.cv.value != '') {
		var cvExt = getFileExtention(document.form.cv.value).toLowerCase();
		if (!(cvExt == '.bmp' || cvExt == '.gif' || cvExt == '.png' || cvExt == '.jpg' || cvExt == '.doc' || cvExt == '.htm' || cvExt == '.pdf' || 
			cvExt == '.txt' || cvExt == '.sxw' || cvExt == '.odt' || cvExt == '.stw' || cvExt == '.ott' || cvExt == '.rtf' || cvExt == '.xls' || 
			cvExt == '.xlt' || cvExt == '.ods' || cvExt == '.ots' || cvExt == '.sxc' || cvExt == '.stc')) {
			alertMessage += '- Curriculum Vitae bevat geen geldig bestand.\n';
		}
	}
	
	if (document.form.pasfoto.value != '') {
		var pasfotoExt = getFileExtention(document.form.pasfoto.value).toLowerCase();
		if (!(pasfotoExt == '.pdf' || pasfotoExt == '.gif' || pasfotoExt == '.bmp' || pasfotoExt == '.jpg' || pasfotoExt == '.png')) {
			alertMessage += '- Pasfoto bevat geen afbeelding, toegestaan zijn: PDF, GIF, BMP, JPG en PNG bestanden.\n';
		}
	}

	//Telefoon / mobiel / email
	if ( !validPhoneOrEmpty(document.form.telefoon.value) ) alertMessage += '- Telefoon nummer is niet correct\n';
	if ( !validPhoneOrEmpty(document.form.mobiel.value) ) alertMessage += '- Mobiel nummer is niet correct\n';
	if ( !validEmailOrEmpty(document.form.email.value) ) alertMessage += '- Emailadres is niet correct\n';
	if (document.form.telefoon.value=='' && document.form.mobiel.value=='' && document.form.email.value=='') alertMessage += '- Telefoon, mobiel of email moet ingevuld worden.\n';


	// Check opleiding(en) and werkervaring(en)
	alertMessage += validateOpleiding(1);
	alertMessage += validateOpleiding(2);
	alertMessage += validateOpleiding(3);
	alertMessage += validateWerkervaring(1);
	alertMessage += validateWerkervaring(2);
	alertMessage += validateWerkervaring(3);


	//When alertmessage contains messages, show an alert box
	if (alertMessage == '') {
		document.form.submit();
	} else {
		alertMessage = 'De volgende fouten zijn opgetreden:\n\n' + alertMessage;
		alert(alertMessage);
		return false;
	}
}